% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropbox.R
\name{db_upload}
\alias{db_upload}
\title{Upload Local Files to Dropbox}
\usage{
db_upload(
  filename,
  dir,
  delete_file = FALSE,
  token_dir = NA,
  token_name = "token_pers.rds"
)
}
\arguments{
\item{filename}{String. Local file's name to upload.}

\item{dir}{String. Directory you wish to upload the file to.}

\item{delete_file}{Boolean. Delete local file after uploading?}

\item{token_dir}{Character. RDS with token local directory. You may set to
NA if you already set your credentials (see \code{get_creds()})}

\item{token_name}{Character. RDS file name with your token's data.}
}
\value{
\code{TRUE} when successfully uploads file.
}
\description{
This function lets the user upload a local file to Dropbox,
using a previously created token or with interactive window.
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}

Other Credentials: 
\code{\link{db_download}()},
\code{\link{get_credentials}()},
\code{\link{get_tweets}()},
\code{\link{mail_send}()},
\code{\link{queryDB}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()},
\code{\link{stocks_file}()},
\code{\link{stocks_report}()}

Other Dropbox: 
\code{\link{db_download}()}
}
\concept{Credentials}
\concept{Dropbox}
\concept{Tools}
