% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plots.R
\name{mplot_conf}
\alias{mplot_conf}
\title{Confussion Matrix Plot}
\usage{
mplot_conf(
  tag,
  score,
  thresh = 0.5,
  abc = TRUE,
  squared = FALSE,
  diagonal = TRUE,
  top = 20,
  subtitle = NA,
  model_name = NULL,
  save = FALSE,
  subdir = NA,
  file_name = "viz_conf_mat.png"
)
}
\arguments{
\item{tag}{Vector. Real known label.}

\item{score}{Vector. Predicted value or model's result.}

\item{thresh}{Integer. Threshold for selecting binary or regression
models: this number is the threshold of unique values we should
have in \code{'tag'} (more than: regression; less than: classification)}

\item{abc}{Boolean. Arrange columns and rows alphabetically?}

\item{squared}{Boolean. Force plot to be squared?}

\item{diagonal}{Boolean. \code{FALSE} to convert diagonal numbers to
zeroes. Ideal to detect must confusing categories.}

\item{top}{Integer. Plot only the most n frequent variables.
Set to \code{NA} to plot all.}

\item{subtitle}{Character. Subtitle to show in plot}

\item{model_name}{Character. Model's name}

\item{save}{Boolean. Save output plot into working directory}

\item{subdir}{Character. Sub directory on which you wish to save the plot}

\item{file_name}{Character. File name as you wish to save the plot}
}
\value{
Plot with confusion matrix results.
}
\description{
This function plots a confussion matrix.
}
\details{
You may use \code{conf_mat()} to get calculate values.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dfr) # Results for AutoML Predictions
lapply(dfr, head)

# Plot for Binomial Model
mplot_conf(dfr$class2$tag, dfr$class2$scores,
  model_name = "Titanic Survived Model"
)

# Plot for Multi-Categorical Model
mplot_conf(dfr$class3$tag, dfr$class3$score,
  model_name = "Titanic Class Model"
)
}
\seealso{
Other ML Visualization: 
\code{\link{mplot_cuts_error}()},
\code{\link{mplot_cuts}()},
\code{\link{mplot_density}()},
\code{\link{mplot_full}()},
\code{\link{mplot_gain}()},
\code{\link{mplot_importance}()},
\code{\link{mplot_lineal}()},
\code{\link{mplot_metrics}()},
\code{\link{mplot_response}()},
\code{\link{mplot_roc}()},
\code{\link{mplot_splits}()},
\code{\link{mplot_topcats}()}
}
\concept{ML Visualization}
