% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdbscan.R
\name{gplot}
\alias{gplot}
\title{gplot}
\usage{
gplot(x, coords, text = FALSE, distances = FALSE)
}
\arguments{
\item{x}{An \code{hdbscan} object.}

\item{coords}{Coordinates for the points clustered in \code{x}.}

\item{text}{If \code{TRUE}, include on the plot labels for each node's index.
If \code{"parent"}, the labels will instead be the index number of the node's
cluster.}

\item{distances}{If \code{TRUE}, draw circles representing the core distances around each point.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot an \code{hdbscan} object, using \code{\link[ggplot2]{ggplot}}. The
plot is primarily intended for diagnostic purposes, but can be useful to undertand
how clusters were generated.
}
\details{
Point color corresponds to clusters, with outliers as the \code{NA} color. Alpha
corresponds to the node's GLOSH score. The segments on the plot
correspond to the connections on the minimum spanning tree. Segment alpha
corresponds to \eqn{\lambda_p}.

If the parameter \code{text} is set to \code{TRUE} or \code{"parent"}, the nodes will
be labelled with the node index number or cluster index number, respectively.
}
\examples{
\dontrun{
library(largeVis)
# The aggregation dataset can be downloaded from https://github.com/elbamos/clusteringdatasets
data(Aggregation)
dat <- as.matrix(Aggregation[, 1:2])
aggregateVis <- largeVis(dat, K = 10, tree_threshold = 100,
                         max_iter = 5, sgd_batches = 1)
clusters <- hdbscan(aggregateVis, verbose = FALSE)
gplot(clusters, dat)
}
}
