% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lasvmPredict.R
\name{lasvmPredict}
\alias{lasvmPredict}
\title{lasvmPredict}
\usage{
lasvmPredict(x, model, verbose = FALSE)
}
\arguments{
\item{x}{data matrix}

\item{model}{trained model}

\item{verbose}{verbose output?}
}
\value{
a list consisting of
	predictions		the predicted labels
}
\description{
Use lasvm to train a given problem.
}
\examples{
model = lasvmR::lasvmTrain (x = as.matrix(iris[seq(1,150,2),1:4]),
	y = (as.numeric(iris[seq(1,150,2),5]) \%\% 2)*2-1,
	gamma = 1,
	cost = 1,
	kernel = 2)
ytrue = (as.numeric(iris[seq(2,150,2),5]) \%\% 2)*2-1
result = lasvmPredict (x = as.matrix(iris[seq(2,150,2),1:4]), model)
ypred = result$predictions
error = sum(abs(ypred - ytrue))/length(ytrue)
cat ("Error rate =", error*100)
}

