% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/png.R
\name{as.png}
\alias{as.png}
\alias{as.png.document}
\alias{as.png.character}
\title{Coerce to PNG}
\usage{
as.png(x, ...)

\method{as.png}{document}(
  x,
  stem = "latexpdf-doc",
  dir = ".",
  clean = TRUE,
  replace = TRUE,
  multipage = TRUE,
  ...
)

\method{as.png}{character}(x, stem, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}

\item{stem}{the stem of a file name (no extension)}

\item{dir}{output directory}

\item{clean}{whether to delete system files after PNG creation}

\item{replace}{whether to delete the pdf file}

\item{multipage}{whether to convert multiple pages of the PDF}
}
\description{
Coerces to PNG. Generic, with methods for character, document, and data.frame.

Coerces to PNG from document. Makes a system call to 'pdflatex', converts resulting file to PNG. Extra arguments passed to \code{\link{as.pdf.document}} and \code{\link{ghostconvert}}.

Coerces character to document, PDF, and then PNG. Extra arguments passed to \code{\link{as.document.character}} and \code{\link{as.png.document}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{document}: document method

\item \code{character}: character method
}}

\seealso{
\code{\link{as.png.character}}

\code{\link{as.png.document}}

\code{\link{as.png.data.frame}}

\code{\link{as.pdf}}

as.pdf.document

ghostconvert

\code{\link{tex2png}}

\code{\link{viewtex}}

\code{\link{ghostconvert}}
}
