% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodCustom.R, R/modelCustom.R,
%   R/methodRandom.R, R/modelPartition.R, R/modelStratify.R
\name{interface-custom}
\alias{interface-custom}
\alias{getName,lcMethodCustom-method}
\alias{getShortName,lcMethodCustom-method}
\alias{prepareData,lcMethodCustom-method}
\alias{fit,lcMethodCustom-method}
\alias{getName,lcModelCustom-method}
\alias{getShortName,lcModelCustom-method}
\alias{converged,lcModelCustom-method}
\alias{postprob,lcModelCustom-method}
\alias{predict.lcModelCustom}
\alias{predictPostprob,lcModelCustom-method}
\alias{clusterTrajectories,lcModelCustom-method}
\alias{trajectories,lcModelCustom-method}
\alias{getName,lcMethodRandom-method}
\alias{getShortName,lcMethodRandom-method}
\alias{fit,lcMethodRandom-method}
\alias{clusterTrajectories,lcModelPartition-method}
\alias{converged,lcModelPartition-method}
\alias{getName,lcModelPartition-method}
\alias{getShortName,lcModelPartition-method}
\alias{postprob,lcModelPartition-method}
\alias{clusterTrajectories,lcModelStratify-method}
\alias{converged,lcModelStratify-method}
\alias{postprob,lcModelStratify-method}
\alias{predictPostprob,lcModelStratify-method}
\title{custom interface}
\usage{
\S4method{getName}{lcMethodCustom}(object)

\S4method{getShortName}{lcMethodCustom}(object)

\S4method{prepareData}{lcMethodCustom}(method, data, verbose)

\S4method{fit}{lcMethodCustom}(method, data, envir, verbose)

\S4method{getName}{lcModelCustom}(object, ...)

\S4method{getShortName}{lcModelCustom}(object, ...)

\S4method{converged}{lcModelCustom}(object, ...)

\S4method{postprob}{lcModelCustom}(object, ...)

\method{predict}{lcModelCustom}(object, ..., newdata = NULL, what = "mu")

\S4method{predictPostprob}{lcModelCustom}(object, newdata = NULL, ...)

\S4method{clusterTrajectories}{lcModelCustom}(object, at = time(object), ...)

\S4method{trajectories}{lcModelCustom}(
  object,
  at = time(object),
  what = "mu",
  clusters = trajectoryAssignments(object),
  ...
)

\S4method{getName}{lcMethodRandom}(object)

\S4method{getShortName}{lcMethodRandom}(object)

\S4method{fit}{lcMethodRandom}(method, data, envir, verbose, ...)

\S4method{clusterTrajectories}{lcModelPartition}(object, at = time(object), ...)

\S4method{converged}{lcModelPartition}(object, ...)

\S4method{getName}{lcModelPartition}(object, ...)

\S4method{getShortName}{lcModelPartition}(object, ...)

\S4method{postprob}{lcModelPartition}(object, ...)

\S4method{clusterTrajectories}{lcModelStratify}(object, at = time(object), ...)

\S4method{converged}{lcModelStratify}(object, ...)

\S4method{postprob}{lcModelStratify}(object, ...)

\S4method{predictPostprob}{lcModelStratify}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{The object to extract the label from.}

\item{method}{The \code{lcMethod} object.}

\item{data}{The data, as a \code{data.frame}, on which the model will be trained.}

\item{verbose}{A \link[R.utils:Verbose]{R.utils::Verbose} object indicating the level of verbosity.}

\item{envir}{The \code{environment} in which the \code{lcMethod} should be evaluated}

\item{...}{Additional arguments.}

\item{newdata}{Optional data frame for which to compute the posterior probability. If omitted, the model training data is used.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}

\item{at}{An optional vector, list or data frame of covariates at which to compute the cluster trajectory predictions.
If a vector is specified, this is assumed to be the time covariate. Otherwise, a named list or data frame must be provided.}

\item{clusters}{The cluster assignments for the strata to base the trajectories on.}
}
\description{
custom interface
}
\seealso{
\link{lcMethodCustom} \link{lcModelCustom} \link{lcMethodRandom} \link{lcMethodStratify} \link{lcModelPartition} \link{lcModelWeightedPartition}
}
\keyword{internal}
