% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{update.lcMethod}
\alias{update.lcMethod}
\title{Update a method specification}
\usage{
\method{update}{lcMethod}(object, ..., .eval = FALSE, .remove = character(), envir = NULL)
}
\arguments{
\item{object}{The \code{lcMethod} object.}

\item{...}{The new or updated method argument values.}

\item{.eval}{Whether to assign the evaluated argument values to the method. By default (\code{FALSE}), the argument expression is preserved.}

\item{.remove}{Names of arguments that should be removed.}

\item{envir}{The \code{environment} in which to evaluate the arguments. If \code{NULL}, the environment associated with the object is used. If not available, the \code{parent.frame()} is used.}
}
\value{
The new \code{lcMethod} object with the additional or updated arguments.
}
\description{
Update a method specification
}
\details{
Updates or adds arguments to a \code{lcMethod} object. The inputs are evaluated in order to determine the presence of \code{formula} objects, which are updated accordingly.
}
\examples{
m <- lcMethodMixtoolsGMM(Value ~ 1)
m2 <- update(m, formula = ~ . + Time)

m3 <- update(m2, nClusters = 3)

k <- 2
m4 <- update(m, nClusters = k) # nClusters: k

m5 <- update(m, nClusters = k, .eval = TRUE) # nClusters: 2

}
\seealso{
Other lcMethod functions: 
\code{\link{[[,lcMethod-method}},
\code{\link{as.data.frame.lcMethods}()},
\code{\link{as.data.frame.lcMethod}()},
\code{\link{as.lcMethods}()},
\code{\link{as.list.lcMethod}()},
\code{\link{evaluate.lcMethod}()},
\code{\link{formula.lcMethod}()},
\code{\link{lcMethod-class}},
\code{\link{names,lcMethod-method}}
}
\concept{lcMethod functions}
