% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/method.R, R/zzz.R
\name{latrend-generics}
\alias{latrend-generics}
\alias{getName,NULL-method}
\alias{getShortName,NULL-method}
\title{Method- and model-specific generics defined by the latrend package}
\usage{
clusterProportions(object, ...)

clusterTrajectories(object, ...)

compose(method, envir, ...)

converged(object, ...)

externalMetric(
  object,
  object2,
  name = getOption("latrend.externalMetric"),
  ...
)

estimationTime(object, unit = "secs", ...)

fit(method, data, envir, verbose, ...)

fittedTrajectories(
  object,
  at = time(object),
  what = "mu",
  clusters = trajectoryAssignments(object),
  ...
)

getArgumentDefaults(object, ...)

getArgumentExclusions(object, ...)

getLabel(object, ...)

getName(object, ...)

getShortName(object, ...)

idVariable(object, ...)

metric(object, name = getOption("latrend.metric", c("WRSS", "APPA.mean")), ...)

plotFittedTrajectories(object, ...)

plotClusterTrajectories(object, ...)

postFit(method, data, model, envir, verbose, ...)

postprob(object, ...)

predictAssignments(object, newdata = NULL, ...)

predictForCluster(object, newdata = NULL, cluster, ...)

predictPostprob(object, newdata = NULL, ...)

prepareData(method, data, verbose, ...)

preFit(method, data, envir, verbose, ...)

qqPlot(object, ...)

responseVariable(object, ...)

strip(object, ...)

timeVariable(object, ...)

trajectoryAssignments(object, ...)

validate(method, data, envir, ...)

\S4method{getName}{`NULL`}(object, ...)

\S4method{getShortName}{`NULL`}(object, ...)
}
\arguments{
\item{object}{The object.}

\item{...}{Arguments.}

\item{method}{The method.}

\item{envir}{\code{environment}.}

\item{object2}{The model to compare with.}

\item{name}{Metric name.}

\item{unit}{Time unit.}

\item{data}{\code{data.frame}.}

\item{verbose}{\link[R.utils:Verbose]{R.utils::Verbose}.}

\item{at}{A vector of times at which to compute the cluster trajectories.}

\item{what}{Parameter.}

\item{newdata}{\code{data.frame} of newdata.}

\item{cluster}{Cluster name.}
}
\value{
The stripped (i.e., updated) object.
}
\description{
List of S4 generic methods which have no general use other than supporting
functions with signatures of \code{lcMethod} or \code{lcModel}.

Reduce the (serialized) memory footprint of an object.
}
\details{
Serializing references to environments results in the serialization of the object
together with any associated environments and references. This method removes those environments
and references, greatly reducing the serialized object size.
}
\keyword{internal}
