% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodLcmmGMM.R
\name{lcMethodLcmmGMM}
\alias{lcMethodLcmmGMM}
\title{Specify GMM method using lcmm}
\usage{
lcMethodLcmmGMM(
  fixed,
  mixture = ~1,
  random = ~1,
  classmb = ~1,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  init = "lme",
  nClusters = 2,
  ...
)
}
\arguments{
\item{fixed}{The fixed effects formula.}

\item{mixture}{The mixture-specific effects formula. See \link[lcmm:hlme]{lcmm::hlme} for details.}

\item{random}{The random effects formula. See \link[lcmm:hlme]{lcmm::hlme} for details.}

\item{classmb}{The cluster membership formula for the multinomial logistic model. See \link[lcmm:hlme]{lcmm::hlme} for details.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable. This replaces the \code{subject} argument of \link[lcmm:hlme]{lcmm::hlme}.}

\item{init}{Alternative for the \code{B} argument of \link[lcmm:hlme]{lcmm::hlme}, for initializing the hlme fitting procedure.
This is only applicable for \code{nClusters > 1}.
Options:
\itemize{
\item \code{"lme.random"} (default): random initialization through a standard linear mixed model. Assigns a fitted standard linear mixed model enclosed in a call to random() to the \code{B} argument.
\item \code{"lme"}, fits a standard linear mixed model and passes this to the \code{B} argument.
\item \code{"gridsearch"}, a gridsearch is used with initialization from \code{"lme.random"}, following the approach used by \link[lcmm:gridsearch]{lcmm::gridsearch}. To use this initalization, specify arguments \code{gridsearch.maxiter} (max number of iterations during search), \code{gridsearch.rep} (number of fits during search), and \code{gridsearch.parallel} (whether to enable \link[=latrend-parallel]{parallel computation}).
\item \code{NULL} or \code{"default"}, the default \link[lcmm:hlme]{lcmm::hlme} input for \code{B} is used.
}

The argument is ignored if the \code{B} argument is specified, or \code{nClusters = 1}.}

\item{nClusters}{The number of clusters to fit. This replaces the \code{ng} argument of \link[lcmm:hlme]{lcmm::hlme}.}

\item{...}{Arguments passed to \link[lcmm:hlme]{lcmm::hlme}.
The following arguments are ignored: data, fixed, random, mixture, subject, classmb, returndata, ng, verbose, subset.}
}
\description{
Growth mixture modeling through latent-class linear mixed modeling.
}
\examples{
data(latrendData)

if (rlang::is_installed("lcmm")) {
  method <- lcMethodLcmmGMM(
    fixed = Y ~ Time,
    mixture = ~ Time,
    random = ~ 1,
    id = "Id",
    time = "Time",
    nClusters = 2
  )
  gmm <- latrend(method, data = latrendData)
  summary(gmm)

  # define method with gridsearch
  method <- lcMethodLcmmGMM(
    fixed = Y ~ Time,
    mixture = ~ Time,
    random = ~ 1,
    id = "Id",
    time = "Time",
    nClusters = 3,
    init = "gridsearch",
    gridsearch.maxiter = 10,
    gridsearch.rep = 50,
    gridsearch.parallel = TRUE
  )
}
}
\references{
\insertRef{proustlima2017estimation}{latrend}

\insertRef{proustlima2019lcmm}{latrend}
}
\seealso{
Other lcMethod implementations: 
\code{\link{getArgumentDefaults}()},
\code{\link{getArgumentExclusions}()},
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodFunction}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
