\name{gof}
\alias{gof}
\alias{gof.lvmfit}
\alias{information}
\alias{information.lvmfit}
\alias{logLik.lvmfit}
\alias{moments}
\alias{moments.lvm}
\alias{score}
\alias{score.lvmfit}
\title{Extract model summaries and GOF statistics for model object}
\usage{
  gof(object, ...)

  \method{gof}{lvmfit}(object, chisq=FALSE, level=0.90,
    rmsea.threshold=0.05,all=FALSE,...)

  moments(x,...)

  \method{moments}{lvm}(x, p, debug=FALSE,
    conditional=FALSE, data=NULL, ...)

  \method{logLik}{lvmfit}(object, p=coef(object),
    data=model.frame(object), model=object$estimator,
    weight=Weight(object), weight2=object$data$weight2,
    ...)

  \method{score}{lvmfit}(x, data=model.frame(x), p=pars(x),
    model=x$estimator, weight=Weight(x),
    weight2=x$data$weight2, ...)

  \method{information}{lvmfit}(x,p=pars(x),n=x$data$n,data=model.frame(x),model=x$estimator,weight=Weight(x),
    weight2=x$data$weight2, ...)
}
\arguments{
  \item{object}{Model object}

  \item{x}{Model object}

  \item{p}{Parameter vector used to calculate statistics}

  \item{data}{Data.frame to use}

  \item{weight2}{Optional second data.frame (only for
  censored observations)}

  \item{weight}{Optional weight matrix}

  \item{n}{Number of observations}

  \item{conditional}{If TRUE the conditional moments given
  the covariates are calculated. Otherwise the joint
  moments are calculated}

  \item{model}{String defining estimator, e.g. "gaussian"
  (see \code{estimate})}

  \item{debug}{Debugging only}

  \item{chisq}{Boolean indicating whether to calculate
  chi-squared goodness-of-fit (always TRUE for
  estimator='gaussian')}

  \item{level}{Level of confidence limits for RMSEA}

  \item{rmsea.threshold}{Which probability to calculate,
  Pr(RMSEA<rmsea.treshold)}

  \item{all}{Calculate all (ad hoc) FIT indices: TLI, CFI,
  NFI, SRMR, ...}

  \item{\dots}{Additional arguments to be passed to the low
  level functions}
}
\value{
  A \code{htest}-object.
}
\description{
  Calculates various GOF statistics for model object
  including global chi-squared test statistic and AIC.
  Extract model-specific mean and variance structure,
  residuals and various predicitions.
}
\examples{
m <- lvm(list(y~v1+v2+v3+v4,c(v1,v2,v3,v4)~x))
set.seed(1)
dd <- sim(m,1000)
e <- estimate(m, dd)
gof(e,all=TRUE,rmsea.threshold=0.05,level=0.9)


set.seed(1)
m <- lvm(list(c(y1,y2,y3)~u,y1~x)); latent(m) <- ~u
regression(m,c(y2,y3)~u) <- "b"
d <- sim(m,1000)
e <- estimate(m,d)
rsq(e)
##'
rr <- rsq(e,TRUE)
rr
estimate(rr,contrast=rbind(c(1,-1,0),c(1,0,-1),c(0,1,-1)))
}
\author{
  Klaus K. Holst
}
\keyword{methods}
\keyword{models}

