% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkData.R
\name{checkData}
\alias{checkData}
\alias{checkData.lvm}
\title{Check that Validity of the Dataset}
\usage{
checkData(object, data, trace)

\method{checkData}{lvm}(object, data, trace = TRUE)
}
\arguments{
\item{object}{a \code{lvm} object.}

\item{data}{[data.frame] the dataset used to obtain the object.}

\item{trace}{[logical] when \code{TRUE}, the outcome of the check will be displayed.}
}
\value{
Invisible  \code{TRUE} or \code{FALSE}.
}
\description{
Check whether the dataset can be used to fit the \code{lvm} object.
}
\examples{
m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x
latent(m) <- ~u

d <- sim(m,1e2)

try(checkData(m, d)) # return an error

checkData(m, d[,-4])

try(checkData(m, d[,-(3:4)])) # return an error

}
\concept{
diagnostic
}
