% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var2dummy.R
\name{var2dummy}
\alias{var2dummy}
\alias{var2dummy.list}
\alias{var2dummy.lvm}
\title{Convert Variable Names to Dummy Variables Names.}
\usage{
var2dummy(object, ...)

\method{var2dummy}{list}(object, var, rm.first.factor = TRUE, ...)

\method{var2dummy}{lvm}(object, data = NULL, ...)
}
\arguments{
\item{object}{a \code{lvm} object.}

\item{...}{[internal] additional arguments to be passed from \code{var2dummy.lvm} to \code{var2dummy.list}.}

\item{var}{[character] the variable to be transformed.}

\item{rm.first.factor}{[logical] should the first level of each categorical variable be ignored?}

\item{data}{[data.frame] dataset according to which the model should be updated.}
}
\description{
When dealing with categorical variables, the \code{estimate} function convert the categorical variables into dummy variables.
This function convert a set of variable names to their corresponding name in the model with dummy variables
}
\examples{

\dontrun{
var2dummy <- lavaSearch2:::var2dummy
var2dummy.list <- lavaSearch2:::var2dummy.list
var2dummy.lvm <- lavaSearch2:::var2dummy.lvm

m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u ~ X1+X2
var2dummy(m, var = c("X1","X2"))
categorical(m,labels=c("M","F","MF")) <- ~X1
var2dummy(m, var = c("X1","X2"))
categorical(m,labels=c("1","2","3")) <- ~X2
var2dummy(m, var = c("X1","X2"))
}

}
\keyword{internal}
