% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information2.R
\name{information2}
\alias{information2}
\alias{information2.lm}
\alias{information2.gls}
\alias{information2.lme}
\alias{information2.lvmfit}
\alias{information2.lm2}
\alias{information2.gls2}
\alias{information2.lme2}
\alias{information2.lvmfit2}
\title{Extract The full Information Matrix}
\usage{
information2(object, ...)

\method{information2}{lm}(object, ...)

\method{information2}{gls}(object, ...)

\method{information2}{lme}(object, ...)

\method{information2}{lvmfit}(object, ...)

\method{information2}{lm2}(object, ...)

\method{information2}{gls2}(object, ...)

\method{information2}{lme2}(object, ...)

\method{information2}{lvmfit2}(object, ...)
}
\arguments{
\item{object}{a linear model or a latent variable model}

\item{...}{arguments to be passed to \code{vcov2}.}
}
\value{
A matrix.
}
\description{
Extract the full information matrix from a Gaussian linear model.
}
\examples{
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- Sequence.lvm(0)
set.seed(10)
d <- lava::sim(m,n)

## linear model
e.lm <- lm(formula.lvm,data=d)
info.tempo <- vcov2(e.lm, bias.correct = TRUE)
info.tempo[names(coef(e.lm)),names(coef(e.lm))] - vcov(e.lm)

## latent variable model
e.lvm <- estimate(lvm(formula.lvm),data=d)
vcov.tempo <- vcov2(e.lvm, bias.correct = FALSE)
round(vcov.tempo \%*\% information(e.lvm), 5)

}
\seealso{
\code{\link{sCorrect}} to obtain \code{lm2}, \code{gls2}, \code{lme2}, or \code{lvmfit2} objects.
}
\concept{small sample inference}
