% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureeach.R
\name{lawn_featureeach}
\alias{lawn_featureeach}
\title{Iterate over features in any GeoJSON object}
\usage{
lawn_featureeach(x, fun = NULL, lint = FALSE)
}
\arguments{
\item{x}{any \link{data-GeoJSON} object}

\item{fun}{a Javascript function. if not given, returns self}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
matrix of coordinates, where each row in the matrix is a
coordinate pair
}
\description{
Iterate over features in any GeoJSON object
}
\examples{
x <- "{ type: 'Feature', geometry: null, properties: { foo: 1, bar: 3 } }"

# don't apply any function, identity essentially
lawn_featureeach(x)

lawn_featureeach(lawn_data$points_count)

# appply a function callback
lawn_featureeach(lawn_data$points_count, "z.geometry")
lawn_featureeach(lawn_data$points_count, "z.geometry.type")
lawn_featureeach(lawn_data$points_count, "z.properties")
lawn_featureeach(lawn_data$points_count, "z.properties.population")
}
