% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cordall.R
\name{lawn_coordall}
\alias{lawn_coordall}
\title{Get all coordinates from any GeoJSON object, returning an array
of coordinate arrays.}
\usage{
lawn_coordall(x, lint = FALSE)
}
\arguments{
\item{x}{any \link{data-GeoJSON} object}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
matrix of coordinates, where each row in the matrix is a
coordinate pair
}
\description{
Takes any \link{data-GeoJSON} and returns an array of
coordinate arrays
}
\examples{
lawn_point(c(-74.5, 40)) \%>\% lawn_coordall()

rings <- list(list(
   c(-2.275543, 53.464547),
   c(-2.275543, 53.489271),
   c(-2.215118, 53.489271),
   c(-2.215118, 53.464547),
   c(-2.275543, 53.464547)
))
lawn_polygon(rings) \%>\% lawn_coordall()
}
