% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sj.test.R
\name{sj.test}
\alias{sj.test}
\title{Test of Normality -- SJ Test}
\usage{
sj.test(x, crit.values = c("t.approximation", "empirical"), N = 0)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{crit.values}{a character string specifying how the critical values should be 
obtained, i.e., approximated by the \eqn{t}-distribution (default) or empirically.}

\item{N}{number of Monte Carlo simulations for the empirical critical values.}
}
\value{
A list of class \code{"htest"} with the following components:
\item{statistic}{the standardized test statistic.}
\item{p.value}{the \eqn{p}-value.}
\item{parameter}{the ratio of the classical standard deviation \eqn{S} to
the robust standard deviation \eqn{J}.}
\item{data.name}{a character string giving the name of the data.}
}
\description{
Perform the robust directed test of normality, which is based on the ratio of the 
classical standard deviation \eqn{S} to the robust standard deviation \eqn{J} 
(Average Absolute Deviation from the Median, MAAD) of the sample data. 
See \insertCite{Gel_etal_2007;textual}{lawstat}.
}
\examples{
data(bias)
sj.test(bias)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rqq}}, \code{\link{rjb.test}}, 
\code{\link[tseries]{jarque.bera.test}}
}
\author{
Wallace Hui, Yulia R. Gel, Joseph L. Gastwirth, Weiwen Miao
}
\keyword{distribution}
\keyword{htest}
\keyword{robust}
