% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazy.text.format.R
\name{lazy.text.format}
\alias{lazy.text.format}
\title{Format Text}
\usage{
lazy.text.format(text, italic = FALSE, bold = FALSE, underline = FALSE,
  translate = TRUE)
}
\arguments{
\item{text}{Text to be formatted}

\item{italic}{Logical.  Specifies if text should be italic}

\item{bold}{Logical.  Specifies if text should be bold}

\item{underline}{Logical. Specifies if text should be underlined}

\item{translate}{Logical. Specifies if text should be passed through 
\code{latexTranslate} before printing}
}
\description{
Applies italic, bold, or underlining to a piece of text.  
  May be used within \code{lazy.text} to add emphasis when the entire 
  paragraph does not need to be formatted
}
\details{
This function differs from \code{lazy.text} in that 
\code{lazy.text} produces a paragraph of formatted text while
\code{lazy.text.format} produces smaller blocks.  This allows for 
smaller bits of text to be formatted for emphasis
(see the last example below).
}
\examples{
lazy.text.format("This is the text")
lazy.text.format("This is the text", italic=TRUE)
lazy.text.format("This is the text", bold=TRUE)
lazy.text.format("This is the text", italic=TRUE, bold=TRUE)

lazy.text("The percentage of defective lightbulbs in this sample was ", 
          lazy.text.format("30\\\%", italic=TRUE),
          ". Clearly, this is unacceptable.")

}
\author{
Benjamin Nutter
}
