% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_generate_policy.R
\name{rl_generate_policy}
\alias{rl_generate_policy}
\title{Function performs Reinforcement Learning using the past data to generate model policy}
\usage{
rl_generate_policy(x, states, actions, control)
}
\arguments{
\item{x}{\itemize{
\item Dataframe containing trading data
}}

\item{states}{\itemize{
\item Character vector, Selected states of the System
}}

\item{actions}{\itemize{
\item Character vector, Selected actions executed under environment
}}

\item{control}{\itemize{
\item List, control parameters as defined in the Reinforcement Learning Package
}}
}
\value{
Function returns data frame with reinforcement learning model policy
}
\description{
This function will perform Reinforcement Learning using Trading Data.
It will suggest whether or not it is better to keep using trading systems or not.
Function is just using results of the past performance to generate the recommendation (not a holy grail).

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
Initial policy is generated using a dummy zero values.
This way function starts working directly from the first observation.
However policy 'ON' value will only be generated once the Q value is greater than zero
}
\examples{

  library(dplyr)
  library(ReinforcementLearning)
  library(magrittr)
  library(lazytrade)

  data(data_trades)
  states <- c("tradewin", "tradeloss")
  actions <- c("ON", "OFF")
  control <- list(alpha = 0.7, gamma = 0.3, epsilon = 0.1)
  rl_generate_policy(x = data_trades,
                     states, actions, control)


}
\author{
(C) 2019,2021 Vladimir Zhbanko
}
