% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_generate_password.R
\name{util_generate_password}
\alias{util_generate_password}
\title{R function to generate random passwords for MT4 platform or other needs}
\usage{
util_generate_password(
  salt = "something random",
  pass_len = 8,
  write_file = FALSE,
  file_name = "",
  special_symbols = FALSE
)
}
\arguments{
\item{salt}{string, random text supplied by the user}

\item{pass_len}{integer, number specifying how long should the password be}

\item{write_file}{bool, if true writes result to the txt file}

\item{file_name}{string, indicate path of the file where to write text result}

\item{special_symbols}{bool, if true adds special symbols}
}
\value{
string or text file with password
}
\description{
Utility function to generate random passwords.
Wrapper of cryptographic functions from 'openssl' library in R.
Password length can be customized.
By default function just output randomly generated 8 symbol password suitable for MT4 logins.
It is also possible to create other passwords and include special symbols.
When required, it's possible to write resulting password to the txt file.
Once generated, password is written to the destination supplied by the user.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
Passwords are generated using sha512 cryptographic function from openssl package.
System date and user 'salt' is used to supply initial text for cryptographic function.
Hashing function is using additional 'salt' which will be based on the current System time.
Additionally, only a part of generated string is selected and used for password.
Some letters of generated string are converted from lower to upper case.
}
\examples{

library(stringr)
library(magrittr)
library(openssl)
library(readr)

dir <- normalizePath(tempdir(),winslash = "/")
file_path <- file.path(dir, 'p.txt')

#write to file
util_generate_password(salt = 'random text', file_name = file_path)

#generate 8digit
util_generate_password(salt = 'random text')

#generate password with special symbols
util_generate_password(salt = 'random text', special_symbols = TRUE)

#generate longer password with special symbols
util_generate_password(salt = 'random text', pass_len = 10, special_symbols = TRUE)

}
\author{
(C) 2019, 2021 Vladimir Zhbanko
}
