% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes.R
\name{lcars_elbow}
\alias{lcars_elbow}
\title{LCARS corner elbow}
\usage{
lcars_elbow(
  xmin,
  xmax,
  ymin,
  ymax,
  corner,
  width,
  height,
  ro = width/2,
  ri = height/2,
  n = 20,
  color = "atomic-tangerine",
  draw = TRUE
)
}
\arguments{
\item{xmin}{numeric, scalar left x position.}

\item{xmax}{numeric, scalar right x position.}

\item{ymin}{numeric, scalar bottom y position.}

\item{ymax}{numeric, scalar top y position.}

\item{corner}{integer 1:4 or character: \code{topleft}, \code{topright},
\code{bottomleft}, \code{bottomright}. May be abbreviated as \code{tl},
\code{tr}, \code{br}, \code{bl}.}

\item{width}{numeric, the width of the vertical segment of the bend.}

\item{height}{numeric, the height of the horizontal segment of the bend.}

\item{ro}{radius of the outer rounded corner.}

\item{ri}{radius of the inner rounded corner.}

\item{n}{number of points to define the curve of the inner radial quarter
circle. The number of points then used to define the outer curve and
extensions of the segments are scaled respectively based on this.}

\item{color}{ignored if \code{draw = FALSE}. Can be any color given in hex
format. Named colors must be LCARS colors. See \code{\link{lcarsdata}} for
options.}

\item{draw}{draw the corner. Return values if \code{FALSE}.}
}
\value{
draws a polygon
}
\description{
Draw a, LCARS elbow polygon. This is a 90-degree rounded corner bend for top
left, top right, bottom right and bottom left LCARS corner panels.
}
\examples{
plot(0:1, 0:1)
lcars_elbow(0.1, 0.9, 0.6, 0.9, "tl", 0.2, 0.05)
}
