% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-render.R
\name{renderLcars}
\alias{renderLcars}
\alias{renderLcarsBox}
\alias{renderLcarsSweep}
\title{Create an LCARS outputs (server side)}
\usage{
renderLcarsBox(expr, env = parent.frame(), quoted = FALSE)

renderLcarsSweep(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{An expression that returns a Shiny tag object, HTML, or a list
of such objects.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Server-side functions for creating dynamic \code{lcarBox} and
\code{lcarsSweep}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

  ui <- lcarsPage(
    lcarsBoxOutput("box"),
    lcarsSweepOutput("sweep")
  )

  server <- function(input, output) {
    output$box <- renderLcarsBox({
      lcarsBox()
    })
    output$sweep <- renderLcarsSweep({
      lcarsSweep()
    })
  }

  shinyApp(ui, server)
}
}
\seealso{
\code{\link{lcarsOutput}} for the corresponding UI-side function.
}
