% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville.R
\name{Liouville_marginal}
\alias{Liouville_marginal}
\alias{dliouvm}
\alias{isliouvm}
\alias{pliouvm}
\alias{sliouvm}
\title{Liouville vectors marginal functions}
\usage{
sliouvm(x, family, alpha, theta)

pliouvm(x, family, alpha, theta)

isliouvm(u, family, alpha, theta)

dliouvm(x, family, alpha, theta)
}
\arguments{
\item{x}{vector of quantiles from a Liouville copula (or a Liouville vector for the survival function , with support on the positive real line)}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alpha}{integer Dirichlet parameter}

\item{theta}{parameter of the corresponding Archimedean copula}

\item{u}{vector of quantiles or survival probabilities, (pseudo)-uniform variates}
}
\value{
a vector  with the corresponding quantile, probability, survival probabilities
}
\description{
Marginal density, distribution, survival and inverse survival functions for Liouville copulas or Liouville vectors.
The inverse survival function of Liouville vectors is not available in closed-form and is obtained numerically by root-finding.
As such, Monte-Carlo approximation have been considered for dealing with inference to avoid computational bottlenecks.
Note: the arguments of \code{sliouv} are reversed since they are meant to be called inside \code{optim}. The functions borrow
\eqn{psi} functions and their derivatives from the \code{\link[copula]{copula-package}}.
}
\examples{
\dontrun{
#Marginal density
samp <- rliouv(n = 100, family = "clayton", alphavec <- c(2,3), theta = 2)
dliouvm(x=samp[,1], family="clayton", alpha=2, theta=2)
sum(log(dliouvm(x=samp[,1], family="clayton", alpha=2, theta=2)))
#Marginal distribution and (inverse) survival function
x <- rliouv(n = 100, family = "gumbel", alphavec <- c(2,3), theta = 2)
pliouvm(x[,1], family="gumbel", alpha=alphavec[1], theta=2)
su <- sliouvm(1-x[,1], family="gumbel", alpha=alphavec[1], theta=2)
isliouvm(u=su, family="clayton", alpha=2, theta=2)
#pliouv is the same as sliouv(isliouvm)
}
}

