% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trajectories.R
\name{plot_trajectories}
\alias{plot_trajectories}
\title{Plot individual trajectories}
\usage{
plot_trajectories(
  data,
  id_var,
  var_list,
  line_colour = "blue",
  group_var = NULL,
  point_colour = "black",
  line_alpha = 0.2,
  point_alpha = 0.2,
  point_size = 1,
  smooth = FALSE,
  smooth_method = "loess",
  smooth_se = FALSE,
  xlab = "X",
  ylab = "Y",
  scale_x_num = FALSE,
  scale_x_num_start = 1,
  random_sample_frac = 1,
  seed = 1234,
  title_n = FALSE,
  connect_missing = TRUE
)
}
\arguments{
\item{data}{Dataset in wide format.}

\item{id_var}{String, specifying id variable.}

\item{var_list}{Vector, specifying variable names to be plotted in sequential order.}

\item{line_colour}{String, specifying colour of lines.}

\item{group_var}{String, specifying variable name of group, each group will get individual colour lines. This overwrites the line_colour argument.
Also consider other options to look at trajectories like \link[ggplot2]{facet_wrap} which may be more appropriate.}

\item{point_colour}{String, specifying, colour of points.}

\item{line_alpha}{Numeric, specifying alpha of lines.}

\item{point_alpha}{Numeric, specifying alpha of points.}

\item{point_size}{Numeric, size of  point}

\item{smooth}{Logical, add smoothed conditional means using \link[ggplot2]{geom_smooth}.}

\item{smooth_method}{String, specifying method to be used for calculating average line, see \link[ggplot2]{geom_smooth}.}

\item{smooth_se}{Logical, specifying whether to add standard error of average line or not.}

\item{xlab}{String for x axis label.}

\item{ylab}{String for y axis label.}

\item{scale_x_num}{Logical, if \code{TRUE} print sequential numbers starting from 1 as x axis labels, if \code{FALSE} use variable names.}

\item{scale_x_num_start}{Numeric, if \code{scale_x_num = TRUE} this is the starting value of the x axis.}

\item{random_sample_frac}{The fraction of rows to select (from wide dataset), default is set to 1 (100 percent) of the sample.}

\item{seed}{Set seed for random sample if \code{random_sample_frac} argument is used.}

\item{title_n}{Logical, specifying whether to print title with number and percentage of cases used for the plot.}

\item{connect_missing}{Logical, specifying whether to connect points by \code{id_var} across missing values.}
}
\value{
ggplot2 object
}
\description{
Plot individual trajectories
}
\examples{
# Create plot for construct x
plot_trajectories(data = data_bi_lcsm,
                  id_var = "id", 
                  var_list = c("x1", "x2", "x3", "x4", "x5", 
                               "x6", "x7", "x8", "x9", "x10"))

# Create plot for construct y specifying some ather arguments
plot_trajectories(data = data_bi_lcsm,
                  id_var = "id", 
                  var_list = c("y1", "y2", "y3", "y4", "y5", 
                               "y6", "y7", "y8", "y9", "y10"),
                  xlab = "Time", ylab = "Y Score",
                  connect_missing = FALSE, random_sample_frac = 0.5)

}
