% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getJob.R
\name{getJob}
\alias{getJob}
\alias{getID}
\alias{getRegistry}
\alias{getLDA}
\alias{setFileDir}
\title{Getter and Setter for LDARep and LDABatch}
\usage{
getJob(x)

getID(x)

getRegistry(x)

getLDA(x, job, reduce, all)

setFileDir(x, file.dir)
}
\arguments{
\item{x}{[\code{named list}]\cr
\code{\link{LDABatch}} or \code{\link{LDARep}} object.}

\item{job}{[\code{\link{data.frame}} or \code{integer}]\cr
A data.frame or data.table with a column named "job.id" or a vector of integerish job ids.}

\item{reduce}{[\code{logical(1)}]\cr
If the list of LDAs contains only one element, should the list be reduced and
the single (unnamed) element be returned? Default is \code{TRUE}.}

\item{all}{not implemented for \code{\link{LDABatch}} and \code{\link{LDARep}}
object. See \code{\link[=getSCLOP]{getLDA}}}

\item{file.dir}{[Vector to be coerced to a \code{\link[fs]{fs_path}} object.]\cr
New file directory to overwrite the registry's old one. This can be useful
if the registry is transferred from a batch system.}
}
\description{
Returns the job ids and its parameter set (\code{getJob}) or the (registry's)
id (\code{getID}) for a \code{\link{LDABatch}} or \code{\link{LDARep}} object.
\code{getRegistry} returns the registry itself for a \code{\link{LDABatch}}
object. \code{getLDA} returns the list of \code{\link{LDA}} objects for a
\code{\link{LDABatch}} or \code{\link{LDARep}} object. In addition, you can
specify one or more LDAs by their id(s).\cr
\code{setFilDir} sets the registry's file directory for a
\code{\link{LDABatch}} object. This is useful if you move the registry´s folder,
e.g. if you do your calculations on a batch system, but want to do your
evaluation on your desktop computer.
}
\seealso{
Other getter functions: 
\code{\link{getSCLOP}()},
\code{\link{getSimilarity}()},
\code{\link{getTopics}()}

Other replication functions: 
\code{\link{LDAPrototype}()},
\code{\link{LDARep}()},
\code{\link{as.LDARep}()},
\code{\link{mergeRepTopics}()}

Other batch functions: 
\code{\link{LDABatch}()},
\code{\link{as.LDABatch}()},
\code{\link{mergeBatchTopics}()}
}
\concept{batch functions}
\concept{getter functions}
\concept{replication functions}
