% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_sort.R
\name{quantile.lvec}
\alias{quantile.lvec}
\title{Calculate the quantiles of an lvec}
\usage{
\method{quantile}{lvec}(x, probs = seq(0, 1, 0.25), names = TRUE,
  na.rm = TRUE, true_probs = FALSE, ...)
}
\arguments{
\item{x}{an object of type \code{\link{lvec}}.}

\item{probs}{a numeric vector with probabilities ([0,1]).}

\item{names}{add names to the result vector.}

\item{na.rm}{remove missing values before calculating the quantiles}

\item{true_probs}{add an attribute with the probabilities at the chosen 
pivots.}

\item{...}{ignored.}
}
\description{
Calculate the quantiles of an lvec
}
\details{
This function uses a more simple method than that used by the regular 
\code{\link{quantile}} method. It sorts the vector (using 
\code{\link{partial_sort}} for speed) and selects elements from \code{x} 
that correspond to the given probabilities. For example, when \code{x} has 
length of 11 and \code{prob} equal to 0.5, it selects the 6th element from 
the (partially) sorted \code{x}. For large enough vectors this is a 
reasonable approach.
}
