% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-constructor.R
\name{ldhmm}
\alias{ldhmm}
\title{Constructor of ldhmm class}
\usage{
ldhmm(m, param, gamma, delta = NULL, stationary = TRUE)
}
\arguments{
\item{m}{numeric, number of states}

\item{param}{matrix, the ecld parameters of states.}

\item{gamma}{matrix, the transition probability matrix, must be m by m.}

\item{delta}{numeric, the initial distribution for each state, default is \code{NULL}.}

\item{stationary}{logical, specify whether the initial distribution is stationary or not,
default is \code{TRUE}.}
}
\value{
An object of ldhmm class
}
\description{
Construct an ldhmm class by providing the required parameters.
}
\examples{
param0 <- matrix(c(0.003, 0.02, 1, -0.006, 0.03, 1.3), 2, 3, byrow=TRUE)
gamma0 <- matrix(c(0.9, 0.1, 0.1, 0.9), 2, 2, byrow=TRUE)
d <- ldhmm(m=2, param=param0, gamma=gamma0)

}
\author{
Stephen H. Lihn
}
\keyword{constructor}

