% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{propagate}
\alias{propagate}
\title{State propagation}
\usage{
propagate(theta, u, v, y, stdlik = TRUE)
}
\arguments{
\item{theta}{A list of system parameters (A, B, C, D, Q, R)'}

\item{u}{Input matrix for the state equation (m_u rows, T columns)}

\item{v}{Input matrix for the output equation (m_v rows, T columns)}

\item{y}{Observations}

\item{stdlik}{Boolean, whether the likelihood is divided by the number of observations. Standardizing the likelihood this way may speed up convergence in the case of long time series.}
}
\value{
A list of predictions and log-likelihood (X, Y, V, lik)
}
\description{
This function propagates the state trajectory based on the exogenous inputs only
(without measurement update), and calculates the corresponding log-likelihood
}
\section{Note}{
 This code only works on one dimensional state and output at the moment. Therefore, transposing is skipped, and matrix inversion is treated as /, and log(det(Sigma)) is treated as log(Sigma).
}

