% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{DcEstim}
\alias{DcEstim}
\title{Estimates an Discrete Choice Model}
\usage{
DcEstim(
  y,
  x,
  w = NULL,
  distType = "logit",
  newX = NULL,
  pcaOptionsX = NULL,
  costMatrices = NULL,
  simFixSize = 200L,
  simTrainRatio = 0.5,
  simTrainFixSize = 0L,
  simSeed = 0L,
  weightedEval = FALSE,
  printMsg = FALSE
)
}
\arguments{
\item{y}{(numeric matrix) Data with dependent variable in the column. Given the number of choices 'n', it must contain 0,1,...,n-1 and 'sum(y==i)>0' for i=0,...,n-1.}

\item{x}{(numeric matrix) Exogenous data with variables in the columns.}

\item{w}{(numeric vector) Weights of the observations in \code{y}. Null means equal weights.}

\item{distType}{(string) Distribution assumption. It can be \code{logit} or \code{probit}.}

\item{newX}{(numeric matrix) If not null, probabilities are projected for each row of this matrix.}

\item{pcaOptionsX}{(list) A list of options in order to use principal components of the \code{x}, instead of the actual values. set null to disable. Use \code{\link[=GetPcaOptions]{GetPcaOptions()}} for initialization.}

\item{costMatrices}{(list of matrices) Each cost table determines how you score the calculated probabilities.}

\item{simFixSize}{(int) Number of pseudo out-of-sample simulations. Use zero to disable the simulation. (see \code{\link[=GetMeasureOptions]{GetMeasureOptions()}}).}

\item{simTrainRatio}{(double) Size of the training sample as a ratio of the number of the observations. It is effective only if \code{simTrainFixSize} is zero.}

\item{simTrainFixSize}{(int) A fixed size for the training sample. If zero, \code{simTrainRatio} is used.}

\item{simSeed}{(int) A seed for the pseudo out-of-sample simulation.}

\item{weightedEval}{(bool) If true, weights will be used in evaluations.}

\item{printMsg}{(bool) Set false to disable printing the details.}
}
\value{
A list:
}
\description{
Estimates an Discrete Choice Model
}
