% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.metric.from.weight}
\alias{s.metric.from.weight}
\title{Convert a Weight to Metric}
\usage{
s.metric.from.weight(value, metricName, minValue = 0)
}
\arguments{
\item{value}{Numeric value of the weight.}

\item{metricName}{Character string specifying the name of the metric.
See \code{\link{get.search.metrics}} function for the list of available options.}

\item{minValue}{A minimum value used in exponential weight formula.}
}
\value{
A numeric value representing the converted weight.
}
\description{
This function converts a weight to its metric equivalent.
}
\details{
See \link{s.weight.from.metric} and \link{get.search.metrics} for more details.

Note that the main purpose of exporting this statistics helper method is to show the inner calculations of the package.
}
\examples{
weight <- s.weight.from.metric(-3.4, "sic")
metric <- s.metric.from.weight(weight, "sic")

}
\seealso{
\link{s.weight.from.metric}
}
