% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{LAHV}
\alias{LAHV}
\title{Leaf Area Height Volume metric}
\usage{
LAHV(lad_profile, LAI.weighting = FALSE, height.weighting = FALSE)
}
\arguments{
\item{lad_profile}{output of the lad.profile function}

\item{LAI.weighting}{boolean, define if LAVH should be weighted by total LAI. default FALSE}

\item{height.weighting}{boolean, define if LAVH should be weighted by the max height. default FALSE}
}
\description{
Calculates the leaf area height volume (LAHV) metric
as described in Almeida et al. (2019).
}
\examples{
# Get the example laz file
normlas.file = system.file("extdata", "lidar_example.laz", package="leafR")

# Calculate LAD from voxelization
VOXELS_LAD = lad.voxels(normlas.file,
                        grain.size = 2)

# Calculate the LAD profile
lad_profile = lad.profile(VOXELS_LAD)

LAHV(lad_profile, LAI.weighting = FALSE, height.weighting = FALSE)
LAHV(lad_profile, LAI.weighting = TRUE, height.weighting = FALSE)
LAHV(lad_profile, LAI.weighting = FALSE, height.weighting = TRUE)
LAHV(lad_profile, LAI.weighting = TRUE, height.weighting = TRUE)

}
\references{
Almeida, D. R. A., Stark, S. C., Chazdon, R., Nelson, B. W., Cesar, R. G., Meli, P., … Brancalion, P. H. S. (2019). The effectiveness of lidar remote sensing for monitoring forest cover attributes and landscape restoration. Forest Ecology and Management, 438, 34–43. <https://doi.org/10.1016/J.FORECO.2019.02.002>
}
