% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leafletsync.R
\name{addLeafletsync}
\alias{addLeafletsync}
\title{Synchronize multiple Leaflet map}
\usage{
addLeafletsync(
  map,
  ids = NULL,
  synclist = "all",
  options = leafletsyncOptions()
)
}
\arguments{
\item{map}{the map}

\item{ids}{the map ids to be synced. If you use a \code{synclist}, you may
leave it \code{NULL.} The unique names and values of \code{synclist} will
be used.}

\item{synclist}{The synchronization list. The default is \code{'all'}, which
creates a list of all possible combinations of \code{ids}. For a more
detailed control, a named list can be passed in this form
\code{list(m1 = c("m2", "m3"), m2 = c("m1", "m3"), m3 = c("m1", "m2"))},
where the names and values represent map-ids. The names of the lists serve
as a basis and the list values are the maps to be kept in sync with the
basemap.}

\item{options}{A named list of options. See \code{\link{leafletsyncOptions}}.
If you want to add different options to multiple maps, you can wrap the
options in a named list, with the names being the map-ids. See the example
in \code{./inst/examples/offset_continuous.R}}
}
\value{
A modified leaflet map
}
\description{
The plugin allows you to synchronize and unsynchronize multiple leaflet maps
in a Shiny application. You can pass additional options
to \code{\link{leafletsyncOptions}}. For more information see
\href{https://github.com/jieter/Leaflet.Sync}{Leaflet.Sync}
}
\note{
If you synchronize multiple maps, a map may not yet be
  initialized and therefore cannot be used. Make sure to use
  \code{addLeafletsync} after all maps have been rendered.
}
\references{
\url{https://github.com/jieter/Leaflet.Sync}
}
\seealso{
Other leafletsync Functions: 
\code{\link{addLeafletsyncDependency}()},
\code{\link{isSynced}()},
\code{\link{leafletsyncOptions}()},
\code{\link{unsync}()}
}
\concept{leafletsync Functions}
