% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlearner.R
\name{dlearner}
\alias{dlearner}
\title{Latent space-based transfer learning}
\usage{
dlearner(Y_source, Y_target, r)
}
\arguments{
\item{Y_source}{matrix containing the source population data}

\item{Y_target}{matrix containing the target population data}

\item{r}{(optional) integer specifying the rank of the knowledge graphs. By default, ScreeNOT (Donoho et al. 2023) is applied to the source population knowledge graph to select the rank.}
}
\value{
A list with the following components:
\item{dlearner_estimate}{matrix containing the D-LEARNER estimate of the target population knowledge graph.}
\item{r}{rank value used.}
}
\description{
This function applies the Direct project LatEnt spAce-based tRaNsfer lEaRning (D-LEARNER) method (McGrath et al. 2024) to leverage data from a source population to improve
estimation of a low rank matrix in an underrepresented target population.
}
\details{
\strong{Data and notation:}

The data consists of a matrix in the target population \eqn{Y_0 \in \mathbb{R}^{p \times q}} and the source population \eqn{Y_1 \in \mathbb{R}^{p \times q}}.
Let \eqn{\hat{U}_{k} \hat{\Lambda}_{k} \hat{V}_{k}^{\top}} denote the truncated singular value decomposition (SVD) of \eqn{Y_k}, \eqn{k = 0, 1}.

For \eqn{k = 0, 1}, one can view \eqn{Y_k} as a noisy version of \eqn{\Theta_k}, referred to as the knowledge graph. The target of inference is the target population knowledge graph, \eqn{\Theta_0}.

\strong{Estimation:}

This method estimates \eqn{\Theta_0} by \eqn{\hat{U}_{1}^{\top}\hat{U}_{1} Y_0 \hat{V}_{1}^{\top}\hat{V}_{1}}.
}
\examples{
res <- dlearner(Y_source = dat_highsim$Y_source,
                Y_target = dat_highsim$Y_target)

}
\references{
Donoho, D., Gavish, M. and Romanov, E. (2023). \emph{ScreeNOT: Exact MSE-optimal singular value thresholding in correlated noise}. The Annals of Statistics, 51(1), pp.122-148.
}
