
<!-- README.md is generated from README.Rmd. Please edit that file -->

# learnrbook

[![cran
version](https://www.r-pkg.org/badges/version/learnrbook)](https://cran.r-project.org/package=learnrbook)

## Purpose

Package ‘learnrbook’ contains data in R objects and in foreign files
used as examples in the book “Learn R: As a Language” by Pedro J.
Aphalo, New York: Chapman and Hall/CRC, 2020, ISBN 9780367182533 (pbk);
ISBN 9780367182557 (hbk); ISBN 9780429060342 (ebk); DOI
[10.1201/9780429060342](https://doi.org/10.1201/9780429060342).

This package also exports as character vectors the names of the packages
used in the book, so as to make it easier to install them.

![](man/figures/cover-9780367182533-small.png)

## Installation

Installation of the most recent stable version from CRAN:

``` r
install.packages("learnrbook")
```

Installation of the current unstable version from Bitbucket:

``` r
# install.packages("devtools")
devtools::install_bitbucket("aphalo/learnrbook-pkg")
```

## Documentation

HTML documentation is available at
(<https://docs.r4photobiology.info/learnrbook/>).

News about updates are regularly posted at
(<https://www.r4photobiology.info/>).

## Contributing

Please report bugs and request new features at
(<https://bitbucket.org/aphalo/learnrbook-pkg/issues>). Pull requests
are welcome at (<https://bitbucket.org/aphalo/learnrbook-pkg>).

## Citation

If you use this package to produce scientific or commercial
publications, please cite according to:

``` r
citation("learnrbook")
#> 
#> Aphalo P (2020). _learnrbook: Datasets for P. J. Aphalo's "Learn R"
#> Book_. R package version 1.0.1, <URL:
#> https://CRAN.R-project.org/package=learnrbook>.
#> 
#> Aphalo P (2020). _Learn R: As a Language_, series R Series. Chapman and
#> Hall/CRC, New York. ISBN 9780367182533, doi: 10.1201/9780429060342
#> (URL: https://doi.org/10.1201/9780429060342), <URL:
#> https://www.routledge.com/Learn-R-As-a-Language/Aphalo/p/book/9780367182533>.
#> 
#> To see these entries in BibTeX format, use 'print(<citation>,
#> bibtex=TRUE)', 'toBibtex(.)', or set
#> 'options(citation.bibtex.max=999)'.
```

## License

© 2018-2020 Pedro J. Aphalo (<pedro.aphalo@helsinki.fi>). Released under
the GPL, version 2 or greater. This software carries no warranty of any
kind.
