% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_FETE_lcps.R
\name{create_FETE_lcps}
\alias{create_FETE_lcps}
\title{Calculate Least-cost Paths from each location to all other locations}
\usage{
create_FETE_lcps(x, locations, cost_distance = FALSE, ncores = 1)
}
\arguments{
\item{x}{\code{conductanceMatrix}}

\item{locations}{\code{sf} 'POINT' or 'MULTIPOINT', \code{SpatVector}, \code{data.frame} or \code{matrix} containing the locations coordinates}

\item{cost_distance}{\code{logical} if TRUE computes total accumulated cost from origin to destination. FALSE (default)}

\item{ncores}{\code{numeric} Number of cores used when calculating least-cost paths from-everywhere-to-everywhere. 1 (default)}
}
\value{
\code{sf} or \code{spatVector} Least-cost paths from-everywhere-to-everywhere based on the supplied \code{conductanceMatrix}. If supplied \code{locations} is a \code{spatVector} object then \code{spatVector} object returned else \code{sf} object
}
\description{
Calculates Least-cost paths from-everywhere-to-everywhere. This is based on the approach proposed by White and Barber (2012).
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(839769, 4199443)),
sf::st_point(c(1038608, 4100024)),
sf::st_point(c(907695, 4145478)),
sf::st_point(c(907695, 4145478)),
crs = terra::crs(r)))

lcps <- create_FETE_lcps(x = slope_cs, locations = locs)
}
\author{
Joseph Lewis
}
