% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cypdata}
\alias{cypdata}
\title{Demographic Dataset of \emph{Cypripedium candidum} Population, in Horizontal
Format}
\format{
A data frame with 77 individuals and 27 variables. Each row 
corresponds to an unique individual, and each variable from \code{size.04} 
on refers to the state of the individual in a particular year.

\describe{
  \item{plantid}{A numberic variable giving a unique number to each 
  individual.}
  \item{patch}{A variable refering to patch within the population.}
  \item{censor}{A variable coding for whether the data point is valid. An
  entry of 1 means that it is so.}
  \item{Inf2.04}{Number of double inflorescences in 2004.}
  \item{Inf.04}{Number of inflorescences in 2004.}
  \item{Veg.04}{Number of stems without inflorescences in 2004.}
  \item{Pod.04}{Number of fruits in 2004.}
  \item{Inf2.05}{Number of double inflorescences in 2005.}
  \item{Inf.05}{Number of inflorescences in 2005.}
  \item{Veg.05}{Number of stems without inflorescences in 2005.}
  \item{Pod.05}{Number of fruits in 2005.}
  \item{Inf2.06}{Number of double inflorescences in 2006.}
  \item{Inf.06}{Number of inflorescences in 2006.}
  \item{Veg.06}{Number of stems without inflorescences in 2006.}
  \item{Pod.06}{Number of fruits in 2006.}
  \item{Inf2.07}{Number of double inflorescences in 2007.}
  \item{Inf.07}{Number of inflorescences in 2007.}
  \item{Veg.07}{Number of stems without inflorescences in 2007.}
  \item{Pod.07}{Number of fruits in 2007.}
  \item{Inf2.08}{Number of double inflorescences in 2008.}
  \item{Inf.08}{Number of inflorescences in 2008.}
  \item{Veg.08}{Number of stems without inflorescences in 2008.}
  \item{Pod.08}{Number of fruits in 2008.}
  \item{Inf2.09}{Number of double inflorescences in 2009.}
  \item{Inf.09}{Number of inflorescences in 2009.}
  \item{Veg.09}{Number of stems without inflorescences in 2009.}
  \item{Pod.09}{Number of fruits in 2009.}
}
}
\source{
Shefferson, R.P., R. Mizuta, and M.J. Hutchings. 2017. Predicting
evolution in response to climate change: the example of sprouting probability
in three dormancy-prone orchid species. \emph{Royal Society Open Science} 
4(1):160647.
}
\usage{
data(cypdata)
}
\description{
A dataset containing the states and fates of \emph{Cypripedium candidum} 
(white lady's slipper orchids), family Orchidaceae, from a population in 
Illinois, USA, resulting from monitoring that occurred annually between 2004 
and 2009.
}
\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", 
                 "Sm", "Md", "Lg", "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector, 
                          repstatus = repvector, obsstatus = obsvector, 
                          matstatus = matvector, propstatus = propvector, 
                          immstatus = immvector, indataset = indataset, 
                          binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004, 
                          patchidcol = "patch", individcol = "plantid", 
                          blocksize = 4, size1col = "Inf2.04", size2col = "Inf.04", 
                          size3col = "Veg.04", repstr1col = "Inf.04", 
                          repstr2col = "Inf2.04", fec1col = "Pod.04", 
                          stageassign = cypframe_raw, stagesize = "sizeadded", 
                          NAas0 = TRUE, NRasRep = TRUE)

rep_cyp_raw <- matrix(0, 11, 11)
rep_cyp_raw[1:2,7:11] <- 0.5

cypover2r <- overwrite(stage3 = c("SD", "P1", "P2", "P3", "SL", "SL", "D", 
                       "XSm", "Sm"), stage2 = c("SD", "SD", "P1", "P2", "P3", 
                       "SL", "SL", "SL", "SL"), eststage3 = c(NA, NA, NA, NA, 
                       NA, NA, "D", "XSm", "Sm"), eststage2 = c(NA, NA, NA, NA, 
                       NA, NA, "XSm", "XSm", "XSm"), givenrate = c(0.1, 0.2, 
                       0.2, 0.2, 0.25, 0.4, NA, NA, NA), type = c("S", "S", "S",
                       "S", "S", "S", "S", "S", "S"))

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, year = "all", 
                       patch = "all", stages = c("stage3", "stage2"),
                       size = c("size3added", "size2added"),
                       repmatrix = rep_cyp_raw, overwrite = cypover2r,
                       yearcol = "year2", patchcol = "patchid",
                       indivcol = "individ")
cypmatrix2r$A[[1]]

}
\keyword{datasets}
