% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gizmo-grob.R
\name{gizmo_grob}
\alias{gizmo_grob}
\title{Guide gizmo: custom grob}
\usage{
gizmo_grob(
  grob,
  width = grobWidth(grob),
  height = grobHeight(grob),
  hjust = 0.5,
  vjust = 0.5,
  position = waiver()
)
}
\arguments{
\item{grob}{A \code{\link[grid:grid.grob]{<grob>}} to display.}

\item{width, height}{A [\verb{<unit[1]>}][grid::unit] setting the allocated
width and height of the the grob respectively.}

\item{hjust, vjust}{A \verb{<numeric[1]>} between 0 and 1 setting the horizontal
and vertical justification of the grob when used as a guide for the \code{x}
and \code{y} aesthetics.}

\item{position}{Where this guide should be drawn: one of \code{"top"}, \code{"bottom"},
\code{"left"}, or \code{"right"}.}
}
\value{
A \verb{<GizmoGrob>} object.
}
\description{
This guide displays a user-provided grob.
}
\examples{
circle <- grid::circleGrob()

# A standard plot with grob gizmos
ggplot(mpg, aes(displ, hwy, colour = cty)) +
  geom_point() +
  guides(
    x.sec = gizmo_grob(
      circle, hjust = 0.75,
      width = unit(2, "cm"), height = unit(2, "cm")
    ),
    colour = gizmo_grob(
      circle, width = unit(1, "cm"), height = unit(1, "cm")
    )
  )
}
\seealso{
Other gizmos: 
\code{\link{gizmo_barcap}()},
\code{\link{gizmo_density}()},
\code{\link{gizmo_histogram}()},
\code{\link{gizmo_stepcap}()}
}
\concept{gizmos}
