% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemon_print.r
\name{lemon_print}
\alias{lemon_print}
\alias{lemon_print.data.frame}
\alias{lemon_print.table}
\title{knitr extension: Always use `kable` for data frames.}
\usage{
lemon_print(x, options, ...)

\method{lemon_print}{data.frame}(x, options, ...)

\method{lemon_print}{table}(x, options, ...)
}
\arguments{
\item{x}{an data frame or dplyr table object to be printed}

\item{options}{Current chunk options are passed through this argument.}

\item{...}{Ignored for now.}
}
\description{
Convenience function for working with R Notebooks that ensures data frames
(and dplyr tables) are printed with \code{\link[knitr]{kable}} while
allowing RStudio to render the data frame dynamically for inline display.
}
\details{
These functions divert data frame and summary output to 
\code{\link[knitr]{kable}} for nicely printing the output.

For \emph{options to \code{kable}}, they can be given directly as 
chunk-options (see arguments to \code{\link[knitr]{kable}}), or though
as a list to a special chunk-option \code{kable.opts}.

For more examples, see \code{vignette('lemon_print', package='lemon')}.
}
\section{Knitr usage}{


To use for a single chunk, do
\preformatted{
```{r render=lemon_print,caption='My data frame'}
data.frame
```
}

\strong{Note:} We are \emph{not} calling the function, 
but instead refering to it.

An alternate route for specifying \code{\link[knitr]{kable}} arguments is as:

\preformatted{
```{r render=lemon_print,kable.opts=list(align='l')}
data.frame
```
}

The option \code{kable.opts} takes precendence over arguments given directly
as chunk-options.

 

To enable as default printing method for \emph{all chunks}, include

\preformatted{
  knit_print.data.frame <- lemon_print
  knit_print.table <- lemon_print
}

\strong{Note:} We are \emph{not} calling the function, 
but instead assigning the \code{\link[knitr]{knit_print}} functions
for some classes.

To disable, temporarily, specify chunk option:
\preformatted{
```{r render=normal_print}`
data.frame
```
}
}
\seealso{
\code{\link[knitr]{knit_print}}, \code{\link[knitr]{kable}}
}

