% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable_show-.r
\name{gtable_show_grill}
\alias{gtable_show_grill}
\alias{gtable_show_names}
\title{Visualise underlying gtable layout.}
\usage{
gtable_show_grill(x, plot = TRUE)

gtable_show_names(
  x,
  plot = TRUE,
  rect.gp = grid::gpar(col = "black", fill = "white", alpha = 1/4)
)
}
\arguments{
\item{x}{A gtable object. If given a ggplot object, it is converted to a
gtable object with \code{\link[ggplot2]{ggplotGrob}}.}

\item{plot}{Logical. When \code{TRUE} (default), draws resulting gtable
object on a new page.}

\item{rect.gp}{Graphical parameters (\code{\link[grid]{gpar}}) for background drop.}
}
\value{
Modified gtable object, invisibly.
}
\description{
Visualises the table structure or the names of the gtable's components.
}
\details{
These functions are highly similar to
\code{\link[gtable]{gtable_show_layout}}.
\code{gtable_show_grill} draws the grid of the underlying table, and places
row and column indicies in the margin.
\code{gtable_show_names} replaces the grobs with a semi-transparent rectangle
and the component's name.
}
\examples{
library(ggplot2)
library(gtable)
library(grid)

p <- ggplot(mtcars, aes(wt, mpg)) + geom_point()

gtable_show_grill(p)
library(ggplot2)
library(gtable)
library(grid)

p <- ggplot(mtcars, aes(wt, mpg)) + geom_point()

gtable_show_names(p)
}
