% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lets_addpoly.R
\name{lets.addpoly}
\alias{lets.addpoly}
\title{Add polygon coverage to a PresenceAbscence object}
\usage{
lets.addpoly(x, y, z, onlyvar = FALSE)
}
\arguments{
\item{x}{A \code{\link{PresenceAbsence}} object.}

\item{y}{Polygon of interest.}

\item{z}{A character indicating the column name of the polygon containing the attributes to be used.}

\item{onlyvar}{If \code{TRUE} only the matrix object will be returned.}
}
\value{
The result is a presence-absence matrix of species with 
the polygons' attributes used added as columns at the right-end of the matrix . The Values represent
the percentage of the cell covered by the polygon attribute used.
}
\description{
Add polygon coverage within cells of a PresenceAbsence object.
}
\examples{
\dontrun{
data(PAM)  # Phyllomedusa presence-absence matrix
require(maptools)
data(wrld_simpl)  # World map
Brazil <- wrld_simpl[wrld_simpl$NAME == "Brazil", ]  # Brazil (polygon)

# Check where is the variable name 
# (in this case it is in "NAME" which will be my z value)
names(Brazil)

PAM_pol <- lets.addpoly(PAM, Brazil, "NAME")
}

}
\seealso{
\code{\link{lets.presab.birds}}

\code{\link{lets.presab}}

\code{\link{lets.addvar}}
}
\author{
Bruno Vilela
}
