#' Augmented SenticNet Polarity Table
#'
#' A \pkg{data.table} dataset containing an augmented version of Cambria, Poria,
#' Bajpai,& Schuller's (2016) positive/negative word list as sentiment lookup
#' values.
#'
#' @details
#' \itemize{
#'   \item x. Words
#'   \item y. Sentiment values
#' }
#'
#' @docType data
#' @keywords datasets
#' @name hash_sentiment_senticnet
#' @usage data(hash_sentiment_senticnet)
#' @format A data frame with 23,627 rows and 2 variables
#' @references Cambria, E., Poria, S., Bajpai, R. and Schuller, B. SenticNet 4:
#' A semantic resource for sentiment analysis based on conceptual primitives.
#' In: COLING, pp. 2666-2677, Osaka (2016)
#' \url{http://sentic.net/downloads}
NULL

