% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsets.R
\name{fsets}
\alias{fsets}
\alias{vars}
\alias{vars<-}
\alias{specs}
\alias{specs<-}
\title{S3 class representing a set of fuzzy sets on the fixed universe}
\usage{
fsets(
  x,
  vars = rep(deparse(substitute(x)), ncol(x)),
  specs = matrix(0, nrow = ncol(x), ncol = ncol(x))
)

vars(f)

vars(f) <- value

specs(f)

specs(f) <- value
}
\arguments{
\item{x}{A matrix of membership degrees. Columns of the matrix represent
fuzzy sets, colnames are names of the fuzzy sets (and must not be NULL). Rows
of the matrix represent elements of the universe.}

\item{vars}{A character vector that must correspond to the
columns of \code{x}. It is a vector of names of original variables that the
fuzzy sets were created from. In other words, the \code{vars} vector should
contain the same value for each \code{x}'s column that corresponds to the same
variable. Names of the \code{vars} vector are ignored.
For instance, an \code{\link[=fcut]{fcut()}} function can transform a single numeric
vector into several different fuzzy sets. To indicate that all of them in
fact describe the same original variable, the same name is stored on
appropriate positions of the \code{vars} vector.}

\item{specs}{A square numeric matrix containing values from \verb{\{0, 1\}}.
It is a specificity matrix, for which both rows and columns correspond to
\code{x}'s columns and where \code{specs[i][j] == 1} if and only if \code{i}-th fuzzy
set (i.e. \code{x[, i]}) is more specific (is a subset or equal to) than \code{j}-th fuzzy
set (i.e. \code{x[, j]}).}

\item{f}{An instance of S3 class \code{fsets}.}

\item{value}{Attribute values to be set to the object.}
}
\value{
\code{\link[=fsets]{fsets()}} returns an object of S3 class \code{fsets}. \code{\link[=vars]{vars()}} returns
a vector of original variable names of the \code{fsets} object. \code{specs}
returns the specificity matrix.
}
\description{
The aim of the \code{fsets} S3 class is to store several fuzzy sets in the
form of numeric matrix where columns represent fuzzy sets, rows are
elements from the universe, and therefore a value of \code{i}-th row and \code{j}-th
column is a membership degree of \code{i}-th element of the universe to \code{j}-th fuzzy
set. The \code{fsets} object also stores the information about
the origin of the fuzzy sets as well as a relation of specificity among
them.
}
\details{
The \code{fsets()} function is a constructor of an object of type \code{fsets}.
Each object stores two attributes: \code{vars} and \code{specs}. The functions \code{\link[=vars]{vars()}}
and \code{\link[=specs]{specs()}}). can be used to access these attributes.

It is assumed that the fuzzy sets
are derived from some raw variables, e.g. numeric vectors or factors. \code{vars}
attribute is a character vector of names of raw variables with size equal
to the number of fuzzy sets in \code{fsets} object. It is then assumed that
two fuzzy sets with the same name in \code{\link[=vars]{vars()}} attribute are derived from
the same variable.

\code{specs} attribute gives a square numeric matrix of size equal to the number
of fuzzy sets in \code{fsets}. \code{specs[i][j] == 1} if and only if the \code{i}-th fuzzy
set is more specific than \code{j}-th fuzzy set. Specificity of fuzzy sets means
the nestedness of fuzzy set: for instance, \verb{very small} is more specific than
\code{small}; similarly, \verb{extremely big} is more specific than \verb{very big}; on the
other hand, \verb{very big} and \verb{extremely small} are incomparable. A necessary
condition for specificity is subsethood.
}
\examples{
    # create a matrix of random membership degrees
    m <- matrix(runif(30), ncol=5)
    colnames(m) <- c('a1', 'a2', 'a12', 'b1', 'b2')

    # create vars - first three (a1, a2, a3) and next two (b1, b2)
    # fuzzy sets originate from the same variable
    v <- c('a', 'a', 'a', 'b', 'b')
    names(v) <- colnames(m)

    # create specificity matrix - a1 and a2 are more specific than a12,
    # the rest is incomparable
    s <- matrix(c(0, 0, 1, 0, 0,
                  0, 0, 1, 0, 0,
                  0, 0, 0, 0, 0,
                  0, 0, 0, 0, 0,
                  0, 0, 0, 0, 0), byrow=TRUE, ncol=5)
    colnames(s) <- colnames(m)
    rownames(s) <- colnames(m)

    # create a valid instance of the fsets class
    o <- fsets(m, v, s)

}
\seealso{
\code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}, \code{\link[=is.specific]{is.specific()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
