% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gridAverageMethods.R
\name{MonteCarloAverage}
\alias{MonteCarloAverage}
\title{MonteCarloAverage function}
\usage{
MonteCarloAverage(funlist, lastonly = TRUE)
}
\arguments{
\item{funlist}{a character vector of names of functions, each accepting single argument Y}

\item{lastonly}{compute average using only time T? (see ?lgcpPredict for definition of T)}
}
\value{
object of class MonteCarloAverage
}
\description{
This function creates an object of class \code{MonteCarloAverage}. The purpose of the function is to compute
Monte Carlo expectations online in the function \code{lgcpPredict}, it is set in the argument \code{gridmeans}
of the argument \code{output.control}.
}
\details{
A Monte Carlo Average is computed as:
\deqn{E_{\pi(Y_{t_1:t_2}|X_{t_1:t_2})}[g(Y_{t_1:t_2})] \approx \frac1n\sum_{i=1}^n g(Y_{t_1:t_2}^{(i)})}{E_{\pi(Y_{t_1:t_2}|X_{t_1:t_2})}[g(Y_{t_1:t_2})] \approx \frac1n\sum_{i=1}^n g(Y_{t_1:t_2}^{(i)})}
where \eqn{g}{g} is a function of interest, \eqn{Y_{t_1:t_2}^{(i)}}{Y_{t_1:t_2}^{(i)}} is the \eqn{i}{i}th retained sample from the target
and \eqn{n}{n} is the total number of retained iterations. For example, to compute the mean of \eqn{Y_{t_1:t_2}}{Y_{t_1:t_2}} set,
\deqn{g(Y_{t_1:t_2}) = Y_{t_1:t_2},}{g(Y_{t_1:t_2}) = Y_{t_1:t_2},}
the output from such a Monte Carlo average would be a set of \eqn{t_2-t_1}{t_2-t_1} grids, each cell of which
being equal to the mean over all retained iterations of the algorithm (NOTE: this is just an example computation, in
practice, there is no need to compute the mean on line explicitly, as this is already done by defaul in \code{lgcpPredict}).
For further examples, see below. The option \code{last=TRUE} computes,
\deqn{E_{\pi(Y_{t_1:t_2}|X_{t_1:t_2})}[g(Y_{t_2})],}{E_{\pi(Y_{t_1:t_2}|X_{t_1:t_2})}[g(Y_{t_2})],}
so in this case the expectation over the last time point only is computed. This can save computation time.
}
\examples{
fun1 <- function(x){return(x)}   # gives the mean
fun2 <- function(x){return(x^2)} # computes E(X^2). Can be used with the
                                 # mean to compute variances, since
                                 # Var(X) = E(X^2) - E(X)^2
fun3 <- exceedProbs(c(1.5,2,3))  # exceedance probabilities,
                                 #see ?exceedProbs
mca <- MonteCarloAverage(c("fun1","fun2","fun3"))
mca2 <- MonteCarloAverage(c("fun1","fun2","fun3"),lastonly=TRUE)
}
\seealso{
\link{setoutput}, \link{lgcpPredict}, \link{GAinitialise}, \link{GAupdate}, \link{GAfinalise}, \link{GAreturnvalue}, \link{exceedProbs}
}

