% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumContrast.R
\name{minimum.contrast}
\alias{minimum.contrast}
\title{minimum.contrast function}
\usage{
minimum.contrast(
  data,
  model,
  method = "g",
  intens = NULL,
  power = 1,
  transform = NULL,
  startvals = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{An object of class 'ppp' (package spatstat) with a polygonal window. May be univariate or multitype.}

\item{model}{Assumed theoretical form of the spatial correlation function. Matches 'model' argument for 'CovarianceFct' in package RandomFields.}

\item{method}{Character string indicating which version of spatial minimum contrast to use: either "K" or "g".}

\item{intens}{Underlying deterministic spatial intensity. A single function f(x,y) or a single pixel image if univariate, a list of these objects if point pattern is multitype (order must correspond to order of ppp marks).}

\item{power}{Power to raise the functions to in the contrast criterion. Default 1.}

\item{transform}{Transformation to apply to the functions in the contrast criterion. Default no transformation.}

\item{startvals}{Starting values for 'optim' in minimising the contrast criterion in the order c(phi,sigma2). A list of these if multitype. If NULL, the function automatically attempts to find suitable starting values, though no guarantee of 'optim' convergence can be given!}

\item{verbose}{Boolean. Whether or not to print function progress.}

\item{...}{Additional arguments to be passed to 'param' in evaluation of 'CovarianceFct' (need dependent upon 'model').}
}
\value{
Returned values are the minimum contrast estimates of phi and sigma^2, as well as the overall squared discrepancy between the parametric and nonparametric forms of the function used corresponding to these estimates. (This can be useful in deciding between several different theoretical forms of the correlation specified by 'model'). If the point pattern is multitype, each pair of parameters is estimated independently for each marginal (type-specific) data set.
}
\description{
A function to provide minimum contrast (aka least squares) estimates of the spatial scale (phi) and spatial variance (sigma^2) assuming an LGCP modelling framework
for spatial data.
}
\seealso{
\link{minimum.contrast.spatiotemporal}, link{chooseCellWidth}, \link{getpolyol}, \link{guessinterp}, \link{getZmat},
\link{addTemporalCovariates}, \link{lgcpPrior}, \link{lgcpInits}, \link{CovFunction}
\link{lgcpPredictSpatialPlusPars}, \link{lgcpPredictAggregateSpatialPlusPars}, \link{lgcpPredictSpatioTemporalPlusPars}, 
\link{lgcpPredictMultitypeSpatialPlusPars}
}
