% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger_config.R
\name{logger_config}
\alias{logger_config}
\alias{as_logger_config}
\alias{as_logger_config.list}
\alias{as_logger_config.character}
\alias{as_logger_config.Logger}
\title{Logger Configuration Objects}
\usage{
logger_config(appenders = list(), threshold = NULL, filters = list(),
  exception_handler = default_exception_handler, propagate = TRUE)

as_logger_config(x)

\method{as_logger_config}{list}(x)

\method{as_logger_config}{character}(x)

\method{as_logger_config}{Logger}(x)
}
\arguments{
\item{appenders}{see \link{Logger}}

\item{threshold}{see \link{Logger}}

\item{filters}{see \link{Logger}}

\item{exception_handler}{see \link{Logger}}

\item{propagate}{see \link{Logger}}

\item{x}{any \R object. Especially:
\itemize{
\item A \code{character} scalar. This can either be the path to a
YAML file or a character scalar containing valid YAML
\item a list containing the elements \code{appenders}, \code{threshold}, \code{exception_handler},
\code{propagate} and \code{filters}. See the section \emph{Fields} in \link{Logger} for
details.
\item a Logger object, to clone its configuration.
}}
}
\value{
a \code{list} with the subclass \code{"logger_config"}

a logger_config object
}
\description{
\code{logger_config()} is an S3 constructor for \code{logger_config} objects
that can be passed to the \code{$config} method of a \link{Logger}. You
can just pass a normal \code{list} instead, but using this constructor is
a more formal way that includes additional argument checking.
}
\examples{
lg <- get_logger("test")

# explicetely defining logger configurations with logger_config

# call without arguments to generate the default configuration
cfg <- logger_config()  # same as the unconfigured state of a Logger
lg$config(cfg)


# Creating a logger config form YAML
cfg <- "
Logger:
  name: test/blubb
  threshold: info
  propagate: false
  appenders:
    AppenderFile:
      file: /tmp/blah.txt
"
lg$config(cfg)  # calls as_logger_config() internally
}
\seealso{
\url{https://yaml.org/}
}
