% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{FilterInject}
\alias{FilterInject}
\title{Inject values into all events processed by a Logger/Appender}
\description{
Inject arbitrary values into all \link[=LogEvent]{LogEvents} processed
by a Logger/Appender. It is recommended to use filters that modify LogEvents
only with Loggers, but they will also work with Appenders.
}
\examples{
lg <- get_logger("test")

analyse <- function(){
  lg$add_filter(FilterInject$new(type = "analysis"), "inject")
  on.exit(lg$remove_filter("inject"))
  lg$error("an error with forced custom 'type'-field")
}

analyse()
lg$error("an normal error")
lg$config(NULL)  # reset config
}
\section{Super class}{
\code{\link[lgr:EventFilter]{lgr::EventFilter}} -> \code{FilterInject}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{values}}{a named \code{list} of values to be injected into each
\link{LogEvent} processed by this filter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FilterInject$new()}}
\item \href{#method-clone}{\code{FilterInject$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new FilterInject
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterInject$new(..., .list = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{..., .list}}{any number of named \R objects that will be injected as
custom fields into all \link[=LogEvent]{LogEvents} processed by the
Appender/Logger that this filter is attached to. See also
\code{\link[=with_log_value]{with_log_value()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterInject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
