% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LayoutDynatrace.R
\name{LayoutDynatrace}
\alias{LayoutDynatrace}
\title{Format log events for output to Dynatrace}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Layout]{lgr::Layout} and can used as a Layout by an \link[lgr:Appender]{lgr::Appender}.
}
\description{
Similar to \link[lgr:LayoutJson]{lgr::LayoutJson}, but with some modifications to prepare data
for Dynatrace.
}
\seealso{
Other Layout: 
\code{\link{LayoutDbi}},
\code{\link{LayoutElasticSearch}}
}
\concept{Layout}
\section{Super class}{
\code{\link[lgr:Layout]{lgr::Layout}} -> \code{LayoutDynatrace}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{toJSON_args}}{a list of values passed on to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}}

\item{\code{transform_event}}{a \code{function} with a single argument \code{event} that
takes a \link[lgr:LogEvent]{lgr::LogEvent} and returns a \code{list}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LayoutDynatrace-new}{\code{LayoutDynatrace$new()}}
\item \href{#method-LayoutDynatrace-format_event}{\code{LayoutDynatrace$format_event()}}
\item \href{#method-LayoutDynatrace-set_toJSON_args}{\code{LayoutDynatrace$set_toJSON_args()}}
\item \href{#method-LayoutDynatrace-set_transform_event}{\code{LayoutDynatrace$set_transform_event()}}
\item \href{#method-LayoutDynatrace-clone}{\code{LayoutDynatrace$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Layout" data-id="toString"><a href='../../lgr/html/Layout.html#method-Layout-toString'><code>lgr::Layout$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutDynatrace-new"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutDynatrace-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDynatrace$new(
  toJSON_args = list(auto_unbox = TRUE),
  transform_event = transform_event_dynatrace
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutDynatrace-format_event"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutDynatrace-format_event}{}}}
\subsection{Method \code{format_event()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDynatrace$format_event(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutDynatrace-set_toJSON_args"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutDynatrace-set_toJSON_args}{}}}
\subsection{Method \code{set_toJSON_args()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDynatrace$set_toJSON_args(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutDynatrace-set_transform_event"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutDynatrace-set_transform_event}{}}}
\subsection{Method \code{set_transform_event()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDynatrace$set_transform_event(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutDynatrace-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutDynatrace-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDynatrace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
