% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppenderPool.R
\name{AppenderPool}
\alias{AppenderPool}
\title{Log to databases via pool}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Appender]{lgr::Appender} and can be uses as an appender by a \link[lgr:Logger]{lgr::Logger}.
}
\description{
Log to a database table using a connection pool from the \strong{pool} package.
This provides better performance and connection management compared to
direct DBI connections, especially for applications with concurrent users.
Like AppenderDbi, it does \emph{not} support case sensitive / quoted column
names, and you are advised to only use all-lowercase names for
custom fields (see \code{...} argument of \link[lgr:LogEvent]{lgr::LogEvent}).
}
\section{Benefits of Pooled Connections}{


Using connection pools instead of direct DBI connections provides several advantages:
\itemize{
\item Connections are reused rather than created for each query
\item Connection management is automated (creation, validation, destruction)
\item Better handles concurrent requests in multi-user applications
\item Improves overall performance by reducing connection overhead
}
}

\section{Buffered Logging}{


Like AppenderDbi, AppenderPool supports buffered logging by setting \code{buffer_size}
to something greater than \code{0}. This buffer is written to the database whenever it is full
(\code{buffer_size}), whenever a LogEvent with a level of \code{fatal} or \code{error} is
encountered (\code{flush_threshold}), or when the Appender is garbage collected
(\code{flush_on_exit}).
}

\section{Creating a New Appender}{


An AppenderPool is linked to a database table via its \code{table} argument. If the
table does not exist it is created either when the Appender is first
instantiated or when the first LogEvent would be written to that table.
It is recommended to create the target table first using an \verb{SQL CREATE TABLE}
statement for more control and safety.
}

\examples{
if (requireNamespace("RSQLite") && requireNamespace("pool")){
  pool <- pool::dbPool(
    drv = RSQLite::SQLite(),
    dbname = ":memory:"
  )

  app <- AppenderPool$new(
    pool = pool,
    table = "log"
  )

  lg <- lgr::get_logger("test/pool")$
    add_appender(app, "db")$
    set_propagate(FALSE)
  lg$info("test")
  print(lg$appenders[[1]]$data)

  invisible(lg$config(NULL)) # cleanup
  pool::poolClose(pool)
}
}
\seealso{
Other Appenders: 
\code{\link{AppenderAWSCloudWatchLog}},
\code{\link{AppenderDbi}},
\code{\link{AppenderDynatrace}},
\code{\link{AppenderElasticSearch}},
\code{\link{AppenderGmail}},
\code{\link{AppenderPushbullet}},
\code{\link{AppenderSendmail}},
\code{\link{AppenderSyslog}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderMemory]{lgr::AppenderMemory}} -> \code{AppenderPool}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{pool}}{a \link[pool:dbPool]{pool connection}}

\item{\code{close_on_exit}}{\code{TRUE} or \code{FALSE}. Close the pool connection
when the Logger is removed? Usually not necessary as pools manage their own lifecycle.}

\item{\code{col_types}}{a named \code{character} vector providing information about the
column types in the database.}

\item{\code{table}}{a \code{character} scalar or a \link[DBI:Id]{DBI::Id} specifying the target
database table}

\item{\code{table_name}}{\code{character} scalar. Like \verb{$table}, but always returns a
\code{character} scalar}

\item{\code{table_id}}{\code{DBI::Id}. Like \verb{$table}, but always returns a \link[DBI:Id]{DBI::Id}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AppenderPool-new}{\code{AppenderPool$new()}}
\item \href{#method-AppenderPool-set_close_on_exit}{\code{AppenderPool$set_close_on_exit()}}
\item \href{#method-AppenderPool-set_pool}{\code{AppenderPool$set_pool()}}
\item \href{#method-AppenderPool-show}{\code{AppenderPool$show()}}
\item \href{#method-AppenderPool-flush}{\code{AppenderPool$flush()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout"><a href='../../lgr/html/Appender.html#method-Appender-set_layout'><code>lgr::Appender$set_layout()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold"><a href='../../lgr/html/Appender.html#method-Appender-set_threshold'><code>lgr::Appender$set_threshold()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="append"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-append'><code>lgr::AppenderMemory$append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="clear"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-clear'><code>lgr::AppenderMemory$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="format"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-format'><code>lgr::AppenderMemory$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_buffer_size"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_buffer_size'><code>lgr::AppenderMemory$set_buffer_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_exit"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_on_exit'><code>lgr::AppenderMemory$set_flush_on_exit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_on_rotate"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_on_rotate'><code>lgr::AppenderMemory$set_flush_on_rotate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_flush_threshold"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_flush_threshold'><code>lgr::AppenderMemory$set_flush_threshold()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="AppenderMemory" data-id="set_should_flush"><a href='../../lgr/html/AppenderMemory.html#method-AppenderMemory-set_should_flush'><code>lgr::AppenderMemory$set_should_flush()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPool-new"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPool-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPool$new(
  pool,
  table,
  threshold = NA_integer_,
  layout = select_dbi_layout(pool::poolCheckout(pool), table),
  close_on_exit = FALSE,
  buffer_size = 0,
  flush_threshold = "error",
  flush_on_exit = TRUE,
  flush_on_rotate = TRUE,
  should_flush = NULL,
  filters = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pool, table}}{see section \emph{Fields}}

\item{\code{threshold, flush_threshold, layout, buffer_size}}{see \link[lgr:AppenderBuffer]{lgr::AppenderBuffer}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPool-set_close_on_exit"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPool-set_close_on_exit}{}}}
\subsection{Method \code{set_close_on_exit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPool$set_close_on_exit(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPool-set_pool"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPool-set_pool}{}}}
\subsection{Method \code{set_pool()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPool$set_pool(pool)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPool-show"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPool-show}{}}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPool$show(threshold = NA_integer_, n = 20)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AppenderPool-flush"></a>}}
\if{latex}{\out{\hypertarget{method-AppenderPool-flush}{}}}
\subsection{Method \code{flush()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderPool$flush()}\if{html}{\out{</div>}}
}

}
}
