% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{compute_Lambda}
\alias{compute_Lambda}
\title{Construct Smoothing Spline Penalty Matrix}
\usage{
compute_Lambda(
  custom_penalty_mat,
  L1,
  wiggle_penalty,
  flat_ridge_penalty,
  K,
  nc,
  unique_penalty_per_predictor,
  unique_penalty_per_partition,
  penalty_vec,
  colnm_expansions,
  just_Lambda = TRUE
)
}
\arguments{
\item{custom_penalty_mat}{Matrix; optional custom ridge penalty structure}

\item{L1}{Matrix; integrated squared second derivative penalty (\eqn{\textbf{L}_1})}

\item{wiggle_penalty, flat_ridge_penalty}{Numeric; smoothing and ridge penalty parameters}

\item{K}{Integer; number of interior knots (\eqn{K})}

\item{nc}{Integer; number of basis columns per partition}

\item{unique_penalty_per_predictor, unique_penalty_per_partition}{Logical; enable predictor/partition-specific penalties}

\item{penalty_vec}{Named numeric; custom penalty values for predictors/partitions}

\item{colnm_expansions}{Character; column names for linking penalties to predictors}

\item{just_Lambda}{Logical; return only combined penalty matrix (\eqn{\boldsymbol{\Lambda}})}
}
\value{
List containing:
\itemize{
  \item Lambda - Combined \eqn{nc \times nc} penalty matrix (\eqn{\boldsymbol{\Lambda}})
  \item L1 - Smoothing spline penalty matrix (\eqn{\textbf{L}_1})
  \item L2 - Ridge penalty matrix (\eqn{\textbf{L}_2})
  \item L_predictor_list - List of predictor-specific penalty matrices (\eqn{\textbf{L}_\text{predictor\_list}})
  \item L_partition_list - List of partition-specific penalty matrices (\eqn{\textbf{L}_\text{partition\_list}})
}

If \code{just_Lambda=TRUE} and no partition penalties, returns only Lambda matrix \eqn{\boldsymbol{\Lambda}}.
}
\description{
Builds penalty matrix combining smoothing spline and ridge penalties with optional
predictor/partition-specific components. Handles custom penalties and scaling.
}
\keyword{internal}
