% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{invert}
\alias{invert}
\title{Matrix Inversion with Fallback Methods}
\usage{
invert(mat, include_warnings = FALSE)
}
\arguments{
\item{mat}{Square matrix to invert}

\item{include_warnings}{Logical; default FALSE for current implementation.}
}
\value{
Inverted matrix or identity matrix if all methods fail
}
\description{
Attempts matrix inversion using multiple methods, falling back to more robust
approaches if standard inversion fails.
}
\details{
Tries methods in order:

1. Direct inversion using \code{armaInv()}

2. Generalized inverse using eigendecomposition

3. Returns identity matrix with warning if both fail

For eigendecomposition, uses a small ridge penalty (\code{1e-16}) for stability and
zeroes eigenvalues below machine precision.
}
\examples{
## Well-conditioned matrix
A <- matrix(c(4,2,2,4), 2, 2)
invert(A) \%**\% A

## Singular matrix falls back to M.P. generalized inverse
B <- matrix(c(1,1,1,1), 2, 2)
invert(B) \%**\% B

}
\keyword{internal}
