% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{dt_add_to_col_names}
\alias{dt_add_to_col_names}
\title{Add string to all column names in a data.table}
\usage{
dt_add_to_col_names(
  DT,
  astring,
  prefix = FALSE,
  exclude = NULL,
  include = NULL
)
}
\arguments{
\item{DT}{A data.table}

\item{astring}{A string to add to each column name}

\item{prefix}{A logical indicating whether the string should be added
to the beginning of each column name, instead of the end.
(default is \code{FALSE})}

\item{exclude}{A quoted vector or column names to exclude from renaming.
Cannot co-exist with \code{include}}

\item{include}{A quoted vector or column names. Changes names of only
these columns. Cannot co-exist with \code{exclude}}
}
\value{
Returns data.table with string appended or prefixed
}
\description{
Takes a data.table and a string. The supplied string will
be added to end of the each column's name. If \code{prefix}
is \code{TRUE}, the string is added to the beginning, instead.
}
\examples{
DT <- as.data.table(iris)

dt_add_to_col_names(DT, "_post")
names(DT)
# [1] "Sepal.Length_post" "Sepal.Width_post"  "Petal.Length_post"
# [4] "Petal.Width_post"  "Species_post"

 DT <- as.data.table(iris)
dt_add_to_col_names(DT, "pre_", prefix=TRUE)
names(DT)
# [1] "pre_Sepal.Length" "pre_Sepal.Width"  "pre_Petal.Length" "pre_Petal.Width"
# [5] "pre_Species"

DT <- as.data.table(iris)
dt_add_to_col_names(DT, "_post", exclude="Species")
names(DT)
# [1] "Sepal.Length_post" "Sepal.Width_post"  "Petal.Length_post"
# [4] "Petal.Width_post"  "Species"

}
